# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 3
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR3_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmony_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Early rounds: Build trust with cooperation
    if len(my_history) < 2:
        return "C"
    
    # Preemptive strike in round 3
    if len(my_history) == 2:
        return "D"
    
    # Mid-game: Alternate to confuse opponent
    if 3 <= len(my_history) < 6:
        if len(my_history) % 2 == 0:
            return "C"
        else:
            return "D"
    
    # Check for opponent's retaliation pattern
    if len(opp_history) >= 2 and opp_history[-2:] == ["D", "D"]:
        return "D"
    
    # Late-game: Exploit if opponent is cooperative
    if len(my_history) >= 6:
        c_count = opp_history.count("C")
        d_count = opp_history.count("D")
        if c_count > d_count:
            return "D"
        else:
            return "C"
    
    # Default to cooperate if all else fails (misleading safety net)
    return "C"